#!/usr/bin/perl
#
# test_before_run.pl - Test, if any ORACLE_TOOLS script is to be run or not
#
# ---------------------------------------------------------
# Copyright 2013, roveda
#
# This file is part of ORACLE_TOOLS.
#
# ORACLE_TOOLS is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# ORACLE_TOOLS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ORACLE_TOOLS.  If not, see <http://www.gnu.org/licenses/>.
#
#
# ---------------------------------------------------------
# Synopsis:
#   perl test_before_run.pl <configuration file>
#
# ---------------------------------------------------------
# Description:
#   This script reads the <configuration file> and gets the 
#   command defined in TEST_BEFORE_RUN. The script executes the 
#   command on system level and returns 0 if it was successful 
#   or it returns 1 if it was not successful.
#
#   It can be used to find out if any script of the ORACLE_TOOLS
#   shall be executed or not. The test may e.g. be a test if a 
#   specific directory is mounted or a process is running.
#
#   Send any hints, wishes or bug reports to: 
#     roveda at universal-logging-system.org
#
# ---------------------------------------------------------
# Options:
#   See the configuration file.
#
# ---------------------------------------------------------
# Restrictions:
#
# ---------------------------------------------------------
# Dependencies:
#   Misc.pm
#
# ---------------------------------------------------------
# Disclaimer:
#   The script has been tested and appears to work as intended,
#   but there is no guarantee that it behaves as YOU expect.
#   You should always run new scripts on a test instance initially.
#
# ---------------------------------------------------------
# Versions:
#
# "@(#)  test_before_run.pl   0.01   2013-08-18   roveda"
#        Creation.
# "@(#)  test_before_run.pl   0.02   2013-08-24   roveda"
#        Support no command as no tests necessary, exit(0)
#
#
#        Change also $VERSION later in this script!
#
# ===================================================================


use strict;
use warnings;

# These are my modules:
use lib ".";
use Misc 0.32;
use Uls2 1.10;

my $VERSION = 0.02;

# ===================================================================
# The "global" variables
# ===================================================================

# Name of this script.
my $CURRPROG = "";

# This keeps the contents of the configuration file
my %CFG;

# ===================================================================
# main
# ===================================================================
#
# -------------------------------------------------------------------
# Get configuration file contents

my $cfgfile = $ARGV[0];
# print "configuration file=$cfgfile\n";

if (! get_config2($cfgfile, \%CFG, "GENERAL")) {
  print STDERR "$CURRPROG: Error: Cannot parse configuration file '$cfgfile' correctly => aborting\n";
  exit(1);
}

# show_hash(\%CFG, "=");
# print "-----\n\n";

my $cmd = $CFG{"GENERAL.TEST_BEFORE_RUN"};
# print "cmd=[$cmd]\n";

if (! $cmd) {
  # Got no command, assume no tests are necessary.
  # print "Continue with script...\n";
  exit(0);
}

my $cmd_out = `$cmd`;
my $result = $?;
# print "result=$result\n";

if ($result != 0) {
  # print "Do not execute script!\n";
  exit(1);
}

# print "Continue with script...\n";
exit(0);


